<?LassoScript

	// This page allows the administrator to edit the global preferences for the site including
	// the global header and footer and the ordering of sections in the site.

	if: ($action >> 'update');

		// Update the global 'prefs' record and the section ordering.
		
		// Store the site title, header, and footer in variables.
		var: 'site_title'=(action_param: 'site_title');
		var: 'site_header'=(action_param: 'site_header');
		var: 'site_footer'=(action_param: 'site_footer');

		// Store the preferences in the preference map.  Any action parameters which start with
		// 'prefs_' are inserted into a map.  This map is then serialized into the database.
		
		var: 'prefs' = (map);
		iterate: action_params, (var: 'temp');
			var: 'key' = $temp->first;
			var: 'value' = $temp->second;
			if: $key->(beginswith: 'prefs_');
				$key -= 'prefs_';
				$prefs->(insert: $key = $value);
			/if;
		/iterate;

		// The action parameter 'sections' includes the ID for each section which needs
		// to be updated with a new sort value.  If the value has changed then the record
		// is updated.
		
		loop: (action_param: 'sections', -count);
			// Store the section ID and sort value in variables and update the section with the new sort value
			var: 'section_id' = (action_param: 'sections', loop_count);
			var: 'section_sort' = (action_param: 'sections_' + $section_id + '_sort');
			inline: -log=$log_level,
					-update,
					-database='op_collaborate', 
					-table='sections',
					-keyfield='id',
					-keyvalue=$section_id,
					'sort'=$section_sort;
			/inline;
		/loop;

		// Find the solitary record in the prefs table and update it or create a new
		// record if the table is empty.  Note that the 'prefs' field is set to a serialized
		// variable.  This allows the map to be stored in the table directly.

		inline: -log=$log_level,
				-search,
				-database='op_collaborate',
				-table='prefs',
				-keyfield='id',
				-maxrecords=1, -uselimit,
				-returnfield='id';
			if: (found_count == 1);
				inline: -log=$log_level,
						-update,
						-database='op_collaborate',
						-table='prefs',
						-keyfield='id',
						-keyvalue=(field: 'id'),
						'footer'=(var: 'site_footer'),
						'header'=(var: 'site_header'),
						'title'=(var: 'site_title'),
						'prefs' = $prefs->serialize;
					if: (error_msg == error_noerror);
						var: 'handled' = true;
					/if;
				/inline;
			else;
				inline: -log=$log_level,
						-add,
						-database='op_collaborate',
						-table='prefs',
						-keyfield='id',
						'id'='1',
						'footer'=(var: 'site_footer'),
						'header'=(var: 'site_header'),
						'title'=(var: 'site_title'),
						'prefs' = $prefs->serialize;
					if: (error_msg == error_noerror);
						var: 'handled' = true;
					/if;
				/inline;
			/if;
		/inline;

	else: $action >> 'cancel';
	
		// Cancel the edit.  The user is dropped out of 'edit' mode.

		var: 'mode' = '';
		var: 'handled' = false;		

	/if;
	
	// Load the preferences and values from the 'prefs' record.  The 'prefs' variable
	// is created by deserialing the value in the 'prefs' field and then inserting each
	// of its values.
	
	inline: -log=$log_level,
			-search,
			-database='op_collaborate',
			-table='prefs',
			-keyfield='id',
			-maxrecords=1, -uselimit;
		if: (found_count == 1);
			var: 'site_title'=(field: 'title');
			var: 'site_header'=(field: 'header');
			var: 'site_footer'=(field: 'footer');
			var: 'prefs' = (map);
			if: (field: 'prefs') >> '<map';
				var: 'temp' = null;
				$temp->(deserialize: (field: 'prefs'));
				$prefs->(insertfrom: $temp->iterator);
			/if;
			var: 'handled' = true;		
		else;
			var: 'handled' = false;
		/if;
	/inline;

	// Define a set of helper tags.  Each tag outputs a checkbox with a clickable
	// label which allows a new color, font family, or font size to be chosen.  By
	// defining these custom tags the code for each of the checkboxes can be modified
	// in one place.
	
	var: 'stylePicker_id' = 0;
	define_tag: 'colorPicker', -required='name', -required='label', -optional='addl';
		$stylePicker_id++;
		local: 'output' = '<input type="checkbox" name="prefs_' + #name + '" id="stylePicker_' + $stylePicker_id + '" value="' + $prefs->(find: #name) + '"' + (($prefs->keys >> #name)?' checked="checked"') + ' /> <a href="" onclick="return stylePicker(this,\'stylePicker_' + $stylePicker_id + '\',\'Type a color name or hex value (e.g. #FFFFFF or white):\',\'color\',\'' + (local: 'addl') + '\');"' + (($prefs->keys >> #name)?' style="color: ' + $prefs->(find: #name) + ';"') + '>' + #label + '</a>';
		return: @#output;
	/define_tag;
	define_tag: 'fontPicker', -required='name', -required='label', -optional='addl';
		$stylePicker_id++;
		local: 'output' = '<input type="checkbox" name="prefs_' + #name + '" id="stylePicker_' + $stylePicker_id + '" value="' + $prefs->(find: #name) + '"' + (($prefs->keys >> #name)?' checked="checked"') + ' /> <a href="" onclick="return stylePicker(this,\'stylePicker_' + $stylePicker_id + '\',\'Type a font family name (e.g. Verdana or Arial):\',\'font-family\',\'' + (local: 'addl') + '\');"' + (($prefs->keys >> #name)?' style="font-family: ' + $prefs->(find: #name) + ';"') + '>' + (if_null: $prefs->(find: #name),#label) + '</a>';
		return: @#output;
	/define_tag;
	define_tag: 'fontSizer', -required='name', -required='label', -optional='addl';
		$stylePicker_id++;
		local: 'output' = '<input type="checkbox" name="prefs_' + #name + '" id="stylePicker_' + $stylePicker_id + '" value="' + $prefs->(find: #name) + '"' + (($prefs->keys >> #name)?' checked="checked"') + ' /> <a href="" onclick="return stylePicker(this,\'stylePicker_' + $stylePicker_id + '\',\'Type a font size (e.g. 12px or large):\',\'font-size\',\'' + (local: 'addl') + '\');"' + (($prefs->keys >> #name)?' style="font-size: ' + $prefs->(find: #name) + ';"') + '>' + (if_null: $prefs->(find: #name),#label) + '</a>';
		return: @#output;
	/define_tag;

	// The remainder of the page shows a form to the user which includes options for the title,
	// header, and footer for the site, font style preferences for the header and footer, and a
	// list of site sections which can be re-ordered.

?>

[if: $handled == true]

<h2>Collaborate</h2>
<div class="group_list" id="page_frame"[if: (var: 'ljax') == true] xmlns="http://www.w3.org/1999/xhtml"[/if]>
	<div class="group"><b class="rboth1 rrightclr"></b><b class="rboth2 rrightclr"></b><b class="rboth3 rrightclr"></b><b class="rboth4 rrightclr"></b>
		<div class="group_title">
			<a href="index.lasso">Home</a> &gt; 
			Site Preferences
		</div>
		<div class="nav">
			[include: 'edit/nav.lasso']
		</div>
		<form action="edit.lasso" method="post">
			<div class="page">
				<input type="hidden" name="mode" value="edit" />
				<input type="hidden" name="section" value="[var: 'section']" />
				<input type="hidden" name="page" value="[var: 'page']" />
				<table>
					<tr>
						<th>Site Title</th>
						<td>
							<input type="text" name="site_title" value="[var: 'site_title']" />
						</td>
					</tr>
					<tr>
						<th>Site Header</th>
						<td>
							<textarea name="site_header" cols="40" rows="4">[var: 'site_header']</textarea>
							<br />[colorPicker: 'site_header_color','Text Color']
							[fontPicker: 'site_header_fontfamily','Font Family']
							[fontSizer: 'site_header_fontsize','Font Size']
							<br /><input type="checkbox" name="prefs_site_header_fontweight" value="bold"[if: ($prefs->(find: 'site_header_fontweight') == 'bold')] checked="checked"[/if] /> <span style="font-weight: bold">Bold</span>
							<input type="checkbox" name="prefs_site_header_fontstyle" value="italic"[if: ($prefs->(find: 'site_header_fontstyle') == 'italic')] checked="checked"[/if] /> <span style="font-style: italic">Italic</span>
							<input type="checkbox" name="prefs_site_header_fontvariant" value="small-caps"[if: ($prefs->(find: 'site_header_fontvariant') == 'small-caps')] checked="checked"[/if] /> <span style="font-variant: small-caps">Small Caps</span>
							<br /><input type="radio" name="prefs_site_header_textalign" value="left"[if: ($prefs->(find: 'site_header_textalign') == 'left')] checked="checked"[/if] /> Left
							<input type="radio" name="prefs_site_header_textalign" value="center"[if: ($prefs->(find: 'site_header_textalign') == 'center')] checked="checked"[/if] /> Center
							<input type="radio" name="prefs_site_header_textalign" value="right"[if: ($prefs->(find: 'site_header_textalign') == 'right')] checked="checked"[/if] /> Right
						</td>
					</tr>
					<tr>
						<th>Site Footer</th>
						<td>
							<textarea name="site_footer" cols="40" rows="4">[var: 'site_footer']</textarea>
							<br />[colorPicker: 'site_footer_color','Text Color']
							[fontPicker: 'site_footer_fontfamily','Font Family']
							[fontSizer: 'site_footer_fontsize','Font Size']
							<br /><input type="checkbox" name="prefs_site_footer_fontweight" value="bold"[if: ($prefs->(find: 'site_footer_fontweight') == 'bold')] checked="checked"[/if] /> <span style="font-weight: bold">Bold</span>
							<input type="checkbox" name="prefs_site_footer_fontstyle" value="italic"[if: ($prefs->(find: 'site_footer_fontstyle') == 'italic')] checked="checked"[/if] /> <span style="font-style: italic">Italic</span>
							<input type="checkbox" name="prefs_site_footer_fontvariant" value="small-caps"[if: ($prefs->(find: 'site_footer_fontvariant') == 'small-caps')] checked="checked"[/if] /> <span style="font-variant: small-caps">Small Caps</span>
							<br /><input type="radio" name="prefs_site_footer_textalign" value="left"[if: ($prefs->(find: 'site_footer_textalign') == 'left')] checked="checked"[/if] /> Left
							<input type="radio" name="prefs_site_footer_textalign" value="center"[if: ($prefs->(find: 'site_footer_textalign') == 'center')] checked="checked"[/if] /> Center
							<input type="radio" name="prefs_site_footer_textalign" value="right"[if: ($prefs->(find: 'site_footer_textalign') == 'right')] checked="checked"[/if] /> Right
						</td>
					</tr>
					[inline: -log=$log_level,
							-search,
							-database='op_collaborate',
							-table='sections',
							-keyfield='id',
							-maxrecords='all',
							-sortfield='sort']
						[records]
							[var: 'loop_count' = loop_count]
							<tr>
								<th>[if: loop_count == 1]Section Order[else] [/if]</th>
								<td>
									<select name="sections_[field: 'id']_sort">[loop: found_count]
										<option value="[loop_count]"[if: $loop_count == loop_count] selected="selected"[/if]>[loop_count]</option>[/loop]
									</select>
									[field: 'title']
									<input type="hidden" name="sections" value="[field: 'id']" />
								</td>
							</tr>
						[/records]
					[/inline]
				</table>
				<p>
					<input type="submit" name="action" value="Update Site" />
					<input type="submit" name="action" value="Cancel" />
				</p>
			</div>
			<div style="clear: both;"><br /></div>
		</form>
	</div>
	<div class="group">
		<div class="group_title"><a href="index.lasso">View This Site</a></div>
	</div>
</div>
[/if]